(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     71402,       1617]
NotebookOptionsPosition[     68451,       1531]
NotebookOutlinePosition[     69118,       1554]
CellTagsIndexPosition[     69075,       1551]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["5", "BookChapterNumber",
 CellChangeTimes->{
  3.4920567472269897`*^9, {3.4986609098140597`*^9, 3.49866091087486*^9}, 
   3.500692299145839*^9}],

Cell["\:0410\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\
\:0438\:0435 \:0447\:0438\:0441\:043b\:0430", "BookChapterTitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.},
 CellChangeTimes->{{3.49201805371*^9, 3.4920180661275997`*^9}, 
   3.4920193984456*^9, 3.4920194623900003`*^9, 3.4920196446136*^9, {
   3.4986609168340597`*^9, 3.4986609265684595`*^9}, {3.5006923245426393`*^9, 
   3.500692330377039*^9}}],

Cell["\<\
\:0410\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\
\:0435 \:0447\:0438\:0441\:043b\:0430 \:0431\:044b\:043b\:0438 \:0432\:0432\
\:0435\:0434\:0435\:043d\:044b \:0438 \:0432\:043f\:043e\:0441\:043b\:0435\
\:0434\:0441\:0442\:0432\:0438\:0438 \:0438\:0437\:0443\:0447\:0430\:043b\
\:0438\:0441\:044c \:0441 \:0446\:0435\:043b\:044c\:044e \:0440\:0435\:0448\
\:0435\:043d\:0438\:044f \:0437\:0430\:0434\:0430\:0447 \:043f\:0440\:043e \
\:043e\:0431\:044b\:0447\:043d\:044b\:0435 \:0446\:0435\:043b\:044b\:0435 \
\:0447\:0438\:0441\:043b\:0430, \:043d\:0430\:043f\:0440\:0438\:043c\:0435\
\:0440 \:0440\:0435\:0448\:0435\:043d\:0438\:044f \:0434\:0438\:043e\:0444\
\:0430\:043d\:0442\:043e\:0432\:044b\:0445 \:0443\:0440\:0430\:0432\:043d\
\:0435\:043d\:0438\:0439. \:0422\:0435\:043e\:0440\:0438\:044f \:0430\:043b\
\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:0445 \
\:0447\:0438\:0441\:0435\:043b \:043e\:0431\:0448\:0438\:0440\:043d\:0430 \
\:0438 \:043d\:0435 \:043f\:0440\:043e\:0441\:0442\:0430. \:0421  \
\:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\
\:043c\:0438 \:0447\:0438\:0441\:043b\:0430\:043c\:0438 \:0441\:0432\:044f\
\:0437\:0430\:043d\:044b \:043d\:0430\:0438\:0431\:043e\:043b\:0435\:0435 \
\:044d\:0444\:0444\:0435\:043a\:0442\:0438\:0432\:043d\:044b\:0435 \:0430\
\:043b\:0433\:043e\:0440\:0438\:0442\:043c\:044b \:043f\:0440\:043e\:0432\
\:0435\:0440\:043a\:0438 \:0431\:043e\:043b\:044c\:0448\:0438\:0445 \:0447\
\:0438\:0441\:0435\:043b \:043d\:0430 \:043f\:0440\:043e\:0441\:0442\:043e\
\:0442\:0443, \:0440\:0430\:0437\:043b\:043e\:0436\:0435\:043d\:0438\:044f \
\:0446\:0435\:043b\:044b\:0445 \:0447\:0438\:0441\:0435\:043b \:043d\:0430 \
\:043c\:043d\:043e\:0436\:0438\:0442\:0435\:043b\:0438, \:0434\:0438\:0441\
\:043a\:0440\:0435\:0442\:043d\:043e\:0433\:043e \:043b\:043e\:0433\:0430\
\:0440\:0438\:0444\:043c\:0438\:0440\:043e\:0432\:0430\:043d\:0438\:044f. \
\:041c\:044b \:043e\:0433\:0440\:0430\:043d\:0438\:0447\:0438\:043c\:0441\
\:044f \:0432 \:044d\:0442\:043e\:043c \:043f\:0430\:0440\:0430\:0433\:0440\
\:0430\:0444\:0435 \:043b\:0438\:0448\:044c \:043e\:043f\:0438\:0441\:0430\
\:043d\:0438\:0435\:043c \:043d\:0435\:043a\:043e\:0442\:043e\:0440\:044b\
\:0445 \:043f\:0440\:043e\:0441\:0442\:044b\:0445 \:0444\:0430\:043a\:0442\
\:043e\:0432 \:043e\:0431 \:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\
\:0447\:0435\:0441\:043a\:0438\:0445 \:0447\:0438\:0441\:043b\:0430\:0445. \
\>", "Text",
 CellChangeTimes->{{3.4988333072092*^9, 3.4988333420596*^9}, {
   3.4988333721052*^9, 3.4988334631468*^9}, {3.4988335045959997`*^9, 
   3.4988335514272003`*^9}, {3.498833698582*^9, 3.4988337179572*^9}, {
   3.4988337580648003`*^9, 3.4988338962808*^9}, {3.4988339335024*^9, 
   3.4988339457328*^9}, {3.500692618649439*^9, 3.5006926755894394`*^9}, {
   3.5006927105178394`*^9, 3.500692723949439*^9}, {3.500692859716239*^9, 
   3.500692887655839*^9}, {3.500692935189039*^9, 3.500693105946639*^9}, {
   3.500693168237439*^9, 3.5006931804366393`*^9}, {3.500693272398639*^9, 
   3.5006933119602394`*^9}, {3.500695435026639*^9, 3.5006955846618395`*^9}, {
   3.5006956292466393`*^9, 3.500695649370639*^9}, 3.500695684377039*^9, {
   3.500699353659839*^9, 3.500699359135439*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["\:0417\:0430\:0434\:0430\:043d\:0438\:0435 \:0430\
\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:0445\
 \:0447\:0438\:0441\:0435\:043b, \:0432\:044b\:0440\:0430\:0436\:0435\:043d\
\:0438\:0435 \:0432 \:0440\:0430\:0434\:0438\:043a\:0430\:043b\:0430\:0445,   \
                        \:0430\:0440\:0438\:0444\:043c\:0435\:0442\:0438\:0447\
\:0435\:0441\:043a\:0438\:0435 \:043e\:043f\:0435\:0440\:0430\:0446\:0438\
\:0438, \:043c\:0438\:043d\:0438\:043c\:0430\:043b\:044c\:043d\:044b\:0439 \
\:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d \:0438 \:0441\:0442\
\:0435\:043f\:0435\:043d\:044c         ",
 Background->RGBColor[0.9, 1, 1]]], "Section",
 CellChangeTimes->{{3.5007011577530394`*^9, 3.5007012435686393`*^9}, {
  3.500703255282239*^9, 3.5007032919890394`*^9}}],

Cell[TextData[{
 "\:041a\:043e\:043c\:043f\:043b\:0435\:043a\:0441\:043d\:043e\:0435 \:0447\
\:0438\:0441\:043b\:043e \[Alpha] \:043d\:0430\:0437\:044b\:0432\:0430\:0435\
\:0442\:0441\:044f ",
 StyleBox["\:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\
\:043a\:0438\:043c",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 ", \:0435\:0441\:043b\:0438 \:043d\:0430\:0439\:0434\:0435\:0442\:0441\:044f \
\:043e\:0442\:043b\:0438\:0447\:043d\:044b\:0439 \:043e\:0442 \:043d\:0443\
\:043b\:044f \:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d ",
 StyleBox["f(x)\[Element]", "Input"],
 "\[DoubleStruckCapitalQ]",
 StyleBox["[x]", "Input"],
 ", \:0434\:043b\:044f \:043a\:043e\:0442\:043e\:0440\:043e\:0433\:043e ",
 StyleBox["f(\[Alpha])=0", "Input"],
 ". \:0414\:0440\:0443\:0433\:0438\:043c\:0438 \:0441\:043b\:043e\:0432\:0430\
\:043c\:0438 \:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\
\:0441\:043a\:0438\:0435 \:0447\:0438\:0441\:043b\:0430 \:0435\:0441\:0442\
\:044c \:043a\:043e\:0440\:043d\:0438 \:043c\:043d\:043e\:0433\:043e\:0447\
\:043b\:0435\:043d\:043e\:0432 \:0441 \:0440\:0430\:0446\:0438\:043e\:043d\
\:0430\:043b\:044c\:043d\:044b\:043c\:0438 \:043a\:043e\:044d\:0444\:0444\
\:0438\:0446\:0438\:0435\:043d\:0442\:0430\:043c\:0438. \:0412 \:043f\:0430\
\:043a\:0435\:0442\:0435 ",
 StyleBox["Mathematica ",
  FontSlant->"Italic"],
 "\:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\
\:0438\:0435 \:0447\:0438\:0441\:043b\:0430 \:0437\:0430\:0434\:0430\:044e\
\:0442\:0441\:044f c \:043f\:043e\:043c\:043e\:0449\:044c\:044e \:043a\:043e\
\:043c\:0430\:043d\:0434\:044b ",
 StyleBox["Root[f[x],k],", "Input"],
 " \:0433\:0434\:0435 ",
 StyleBox["f[x]", "Input"],
 " \:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d \:0438 k \:043f\
\:043e\:0440\:044f\:0434\:043a\:043e\:0432\:044b\:0439 \:043d\:043e\:043c\
\:0435\:0440 \:0435\:0433\:043e \:043a\:043e\:0440\:043d\:044f. \:041a\:043e\
\:0440\:043d\:0438 \:043d\:0443\:043c\:0435\:0440\:0443\:044e\:0442\:0441\
\:044f \:0432 \:043f\:043e\:0440\:044f\:0434\:043a\:0435 \:0432\:043e\:0437\
\:0440\:0430\:0441\:0442\:0430\:043d\:0438\:044f \:0434\:0435\:0439\:0441\
\:0442\:0432\:0438\:0442\:0435\:043b\:044c\:043d\:044b\:0445 \:0447\:0430\
\:0441\:0442\:0435\:0439. \:0412 \:0442\:0435\:0445 \:0441\:043b\:0443\:0447\
\:0430\:044f\:0445, \:043a\:043e\:0433\:0434\:0430 \:044d\:0442\:043e \:0432\
\:043e\:0437\:043c\:043e\:0436\:043d\:043e, \:043c\:0430\:0442\:0435\:043c\
\:0430\:0442\:0438\:043a\:0430 \:0432\:044b\:0434\:0430\:0451\:0442 \:0440\
\:0430\:0434\:0438\:043a\:0430\:043b\:044c\:043d\:044b\:0435 \:0432\:044b\
\:0440\:0430\:0436\:0435\:043d\:0438\:044f \:0434\:043b\:044f \:043a\:043e\
\:0440\:043d\:0435\:0439. "
}], "Text",
 CellChangeTimes->{{3.4988333072092*^9, 3.4988333420596*^9}, {
   3.4988333721052*^9, 3.4988334631468*^9}, {3.4988335045959997`*^9, 
   3.4988335514272003`*^9}, {3.498833698582*^9, 3.4988337179572*^9}, {
   3.4988337580648003`*^9, 3.4988338962808*^9}, {3.4988339335024*^9, 
   3.4988339457328*^9}, {3.500692618649439*^9, 3.5006926755894394`*^9}, {
   3.5006927105178394`*^9, 3.500692723949439*^9}, {3.500692859716239*^9, 
   3.500692887655839*^9}, {3.500692935189039*^9, 3.500693105946639*^9}, {
   3.500693168237439*^9, 3.500693268264639*^9}, {3.500693324221839*^9, 
   3.500693364001839*^9}, {3.500694776020239*^9, 3.5006949008514395`*^9}, {
   3.500694977057439*^9, 3.500694988289439*^9}, {3.5006951894046392`*^9, 
   3.500695234348239*^9}, {3.5006957067006392`*^9, 3.500695788429039*^9}, {
   3.500697075533039*^9, 3.500697153143039*^9}, {3.5006976789722395`*^9, 
   3.500697684307439*^9}, {3.500699270636639*^9, 3.5006992976870394`*^9}, {
   3.500699373019439*^9, 3.5006993753906393`*^9}, {3.500701266797039*^9, 
   3.500701438865039*^9}, {3.5007014929970393`*^9, 3.5007015261470394`*^9}, {
   3.500701564725839*^9, 3.500701576519439*^9}, {3.5007019668626394`*^9, 
   3.5007020220242395`*^9}, 3.500702076047039*^9}],

Cell[BoxData[{
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "x", "-", "1"}], ",", "1"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"For", "[", 
  RowBox[{
   RowBox[{"k", "=", "1"}], ",", 
   RowBox[{"k", "\[LessEqual]", "5"}], ",", 
   RowBox[{"k", "++"}], ",", 
   RowBox[{
    RowBox[{"a", "=", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "5"}], "-", "1"}], ",", "k"}], "]"}]}], ";", 
    RowBox[{"Print", "[", 
     RowBox[{"a", ",", "\"\<   \>\"", ",", 
      RowBox[{"N", "[", "a", "]"}]}], "]"}]}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"a", "=", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"1", "/", "2"}]}], ",", "2"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", "a"}], ",", "2"}], "]"}]}], "Input",
 CellChangeTimes->{{3.4988326450204*^9, 3.4988327088244*^9}, {
  3.4988327480896*^9, 3.4988328955252*^9}, {3.498832970764*^9, 
  3.498832999546*^9}, {3.4988330440372*^9, 3.4988330566888*^9}, {
  3.4988334679828*^9, 3.4988334879664*^9}, {3.500694921115839*^9, 
  3.500694962799039*^9}, {3.500694998242239*^9, 3.500695003171839*^9}, {
  3.5006951251794395`*^9, 3.5006951671434393`*^9}, {3.5006952713358393`*^9, 
  3.500695378835439*^9}, {3.500696809209839*^9, 3.500697039434639*^9}, {
  3.500697765895439*^9, 3.500697770731439*^9}}],

Cell[TextData[{
 "\:0412 \:0442\:0435\:0445 \:0441\:043b\:0443\:0447\:0430\:044f\:0445, \
\:043a\:043e\:0433\:0434\:0430 \:044d\:0442\:043e \:0432\:043e\:0437\:043c\
\:043e\:0436\:043d\:043e, Mathematica \:0438\:043d\:043e\:0433\:0434\:0430 \
\:0432\:044b\:0434\:0430\:0451\:0442 \:0430\:043b\:0433\:0435\:0431\:0440\
\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:0435 \:0447\:0438\:0441\:043b\
\:0430, \:0437\:0430\:043f\:0438\:0441\:0430\:043d\:043d\:044b\:0435 \:0441 \
\:043f\:043e\:043c\:043e\:0449\:044c\:044e \:0440\:0430\:0434\:0438\:043a\
\:0430\:043b\:043e\:0432.  \:0414\:043b\:044f \:044d\:0442\:043e\:0433\:043e \
\:043c\:043e\:0436\:043d\:043e \:0442\:0430\:043a\:0436\:0435 \:0438\:0441\
\:043f\:043e\:043b\:044c\:0437\:043e\:0432\:0430\:0442\:044c \:043a\:043e\
\:043c\:0430\:043d\:0434\:0443 ",
 StyleBox["ToRadicals.", "Input"],
 " \:0412 \:0441\:043b\:0435\:0434\:0443\:044e\:0449\:0435\:043c \:043f\:0440\
\:0438\:043c\:0435\:0440\:0435 \:043c\:043d\:043e\:0433\:043e\:0447\:043b\
\:0435\:043d \:0438\:043c\:0435\:0435\:0442 \:0442\:0440\:0438 \:0434\:0435\
\:0439\:0441\:0442\:0432\:0438\:0442\:0435\:043b\:044c\:043d\:044b\:0445 \
\:043a\:043e\:0440\:043d\:044f, \:043e\:0434\:043d\:0430\:043a\:043e \:0438\
\:0445 \:043f\:0440\:0435\:0434\:0441\:0442\:0430\:0432\:043b\:0435\:043d\
\:0438\:0435 \:0447\:0435\:0440\:0435\:0437 \:0440\:0430\:0434\:0438\:043a\
\:0430\:043b\:044b \:0432\:043e\:0437\:043c\:043e\:0436\:043d\:043e \:043b\
\:0438\:0448\:044c \:0441 \:043f\:043e\:043c\:043e\:0449\:044c\:044e \:043a\
\:043e\:043c\:043f\:043b\:0435\:043a\:0441\:043d\:044b\:0445 \:0447\:0438\
\:0441\:0435\:043b. "
}], "Text",
 CellChangeTimes->{{3.5006966066646395`*^9, 3.500696678923839*^9}, {
  3.500696717050239*^9, 3.500696772253439*^9}}],

Cell[BoxData[{
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"3", "x"}], "-", "1"}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ToRadicals", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"3", " ", "#1"}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ToRadicals", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"3", " ", "#1"}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ToRadicals", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      RowBox[{"3", " ", "#1"}], "+", 
      SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5006950361814394`*^9, 3.500695075431039*^9}, 
   3.500695327932639*^9, {3.500696032413039*^9, 3.500696060181039*^9}, {
   3.5006960964822392`*^9, 3.500696159365839*^9}, 3.500760560240309*^9}],

Cell[TextData[{
 "\:041a\:043e\:043c\:0430\:043d\:0434\:0430 ",
 StyleBox["RootReduce", "Input"],
 " \:0432\:044b\:0434\:0430\:0451\:0442 \:0441\:0442\:0430\:043d\:0434\:0430\
\:0440\:0442\:043d\:043e\:0435 \:043f\:0440\:0435\:0434\:0441\:0442\:0430\
\:0432\:043b\:0435\:043d\:0438\:0435 \:0430\:043b\:0433\:0435\:0431\:0440\
\:0430\:0438\:0447\:0435\:0441\:043a\:043e\:0433\:043e \:0447\:0438\:0441\
\:043b\:0430, \:0437\:0430\:0434\:0430\:043d\:043d\:043e\:0433\:043e \:0432 \
\:0431\:043e\:043b\:0435\:0435 \:0441\:043b\:043e\:0436\:043d\:043e\:0439 \
\:0444\:043e\:0440\:043c\:0435. \:0412 \:0441\:043b\:0435\:0434\:0443\:044e\
\:0449\:0435\:043c \:043f\:0440\:0438\:043c\:0435\:0440\:0435 \:043e\:043d\
\:0430 \:043f\:0440\:0438\:043c\:0435\:043d\:044f\:0435\:0442\:0441\:044f \
\:043a \:0447\:0438\:0441\:043b\:0443 ",
 StyleBox["b", "Input"],
 StyleBox["=", "Input"],
 StyleBox[Cell[BoxData[
  FormBox[
   RadicalBox["2", "3"], TraditionalForm]], "Input",
  FormatType->"TraditionalForm"], "Input"],
 StyleBox["+", "Input"],
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["3"], "."}], TraditionalForm]], "Input",
  FormatType->"TraditionalForm"], "Input"],
 " "
}], "Text",
 CellChangeTimes->{{3.500697909867839*^9, 3.500698069752239*^9}, {
   3.500698199388239*^9, 3.5006982003086395`*^9}, {3.500698877360639*^9, 
   3.5006988779378395`*^9}, 3.500702141941439*^9}],

Cell[BoxData[
 RowBox[{"b", "=", 
  RowBox[{"RootReduce", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", "3"}], ",", "3"}], "]"}], "+", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "2"}], ",", "2"}], "]"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.500698100999039*^9, 3.5006981786402392`*^9}, {
  3.500698871931839*^9, 3.5006988922742395`*^9}, {3.500698924659839*^9, 
  3.500698925330639*^9}, {3.500699575975439*^9, 3.5006995810922394`*^9}}],

Cell[TextData[{
 "\:0422\:0430\:043a\:0438\:043c \:043e\:0431\:0440\:0430\:0437\:043e\:043c, \
\:0447\:0438\:0441\:043b\:043e ",
 StyleBox["b", "Input"],
 "  \:0435\:0441\:0442\:044c \:043a\:043e\:0440\:0435\:043d\:044c \
\:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d\:0430 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "6"], "-", 
    RowBox[{"6", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"6", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"12", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"36", "x"}], "+", "1"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:043d\:0435 \:0432\:0441\:0435\:0433\:0434\:0430 \:043c\:043e\:0436\:0435\
\:0442 \:0432\:044b\:0434\:0430\:0442\:044c \:0440\:0430\:0434\:0438\:043a\
\:0430\:043b\:044c\:043d\:043e\:0435 \:0432\:044b\:0440\:0430\:0436\:0435\
\:043d\:0438\:0435 \:043a\:043e\:0440\:043d\:044f, \:0434\:0430\:0436\:0435 \
\:0432 \:0442\:043e\:043c, \:0441\:043b\:0443\:0447\:0430\:0435, \:043a\:043e\
\:0433\:0434\:0430 \:043e\:043d\:043e \:0441\:0443\:0449\:0435\:0441\:0442\
\:0432\:0443\:0435\:0442."
}], "Text",
 CellChangeTimes->{{3.5006982554078393`*^9, 3.5006985362390394`*^9}, {
  3.500698567435439*^9, 3.500698722671039*^9}, {3.500698807847039*^9, 
  3.5006988181898394`*^9}, {3.500698957794239*^9, 3.5006989582466393`*^9}, {
  3.500699420833439*^9, 3.500699429491439*^9}, {3.500699592386639*^9, 
  3.5006996152874393`*^9}}],

Cell[BoxData[
 RowBox[{"ToRadicals", "[", "b", "]"}]], "Input",
 CellChangeTimes->{{3.5006987356346393`*^9, 3.5006987930426393`*^9}, {
  3.500698834382639*^9, 3.5006988481730394`*^9}, {3.500698901088239*^9, 
  3.5006989016030393`*^9}, {3.500698947576239*^9, 3.500698948980239*^9}}],

Cell[TextData[{
 "\:0421\:0440\:0435\:0434\:0438 \:0432\:0441\:0435\:0445 \:043c\:043d\:043e\
\:0433\:043e\:0447\:043b\:0435\:043d\:043e\:0432 \:0441 \:0440\:0430\:0446\
\:0438\:043e\:043d\:0430\:043b\:044c\:043d\:044b\:043c\:0438 \:043a\:043e\
\:044d\:0444\:0444\:0438\:0446\:0438\:0435\:043d\:0442\:0430\:043c\:0438, \
\:043e\:0431\:0440\:0430\:0449\:0430\:044e\:0449\:0438\:0445\:0441\:044f \
\:0432 \:043d\:0443\:043b\:044c \:0432 \:0430\:043b\:0433\:0435\:0431\:0440\
\:0430\:0438\:0447\:0435\:0441\:043a\:043e\:0439 \:0442\:043e\:0447\:043a\
\:0435 ",
 StyleBox["\[Alpha]", "Input"],
 ", \:0432\:044b\:0431\:0435\:0440\:0435\:043c \:043c\:043d\:043e\:0433\:043e\
\:0447\:043b\:0435\:043d \:043d\:0430\:0438\:043c\:0435\:043d\:044c\:0448\
\:0435\:0439 \:0441\:0442\:0435\:043f\:0435\:043d\:0438 \:0438 \:0441\:043e \
\:0441\:0442\:0430\:0440\:0448\:0438\:043c \:043a\:043e\:044d\:0444\:0444\
\:0438\:0446\:0438\:0435\:043d\:0442\:043e\:043c 1. \:042d\:0442\:043e\:0442 \
\:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d \:043d\:0430\:0437\
\:044b\:0432\:0430\:0435\:0442\:0441\:044f ",
 StyleBox["\:043c\:0438\:043d\:0438\:043c\:0430\:043b\:044c\:043d\:044b\:043c \
\:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d\:043e\:043c",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 " ",
 StyleBox["\[Alpha]", "Input"],
 ". \:0415\:0433\:043e \:0441\:0442\:0435\:043f\:0435\:043d\:044c \
\:043d\:0430\:0437\:044b\:0432\:0430\:0435\:0442\:0441\:044f ",
 StyleBox["\:0441\:0442\:0435\:043f\:0435\:043d\:044c\:044e",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 " ",
 StyleBox["\[Alpha]", "Input"],
 " \:0438 \:0431\:0443\:0434\:0435\:0442 \:043e\:0431\:043e\:0437\:043d\:0430\
\:0447\:0430\:0442\:044c\:0441\:044f ",
 StyleBox["deg\[Alpha]", "Input"],
 ". \:041c\:0438\:043d\:0438\:043c\:0430\:043b\:044c\:043d\:044b\:0439 \:043c\
\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d \:043d\:0435\:043f\:0440\
\:0438\:0432\:043e\:0434\:0438\:043c \:0432 \:043a\:043e\:043b\:044c\:0446\
\:0435 \[DoubleStruckCapitalQ]",
 StyleBox["[x]", "Input"],
 ". \:0414\:043b\:044f \:0432\:044b\:0447\:0438\:0441\:043b\:0435\:043d\:0438\
\:044f \:043c\:0438\:043d\:0438\:043c\:0430\:043b\:044c\:043d\:043e\:0433\
\:043e \:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d\:0430 \:0441\
\:043b\:0443\:0436\:0438\:0442 \:043a\:043e\:043c\:0430\:043d\:0434\:0430 ",
 StyleBox["MinimalPolynomial[a,x]", "Input"],
 ", \:0433\:0434\:0435 ",
 StyleBox["a", "Input"],
 " \:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\
\:043e\:0435 \:0447\:0438\:0441\:043b\:043e, \:043e\:043f\:0440\:0435\:0434\
\:0435\:043b\:0451\:043d\:043d\:043e\:0435 \:0440\:0430\:043d\:0435\:0435 \
\:0438 ",
 StyleBox["x", "Input"],
 " \:043f\:0435\:0440\:0435\:043c\:0435\:043d\:043d\:0430\:044f, \:043e\:0442 \
\:043a\:043e\:0442\:043e\:0440\:043e\:0439 \:0437\:0430\:0432\:0438\:0441\
\:0438\:0442 \:043c\:0438\:043d\:0438\:043c\:0430\:043b\:044c\:043d\:044b\
\:0439 \:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d. "
}], "Text",
 CellChangeTimes->{{3.5006998968674393`*^9, 3.500699899145039*^9}, {
  3.5007035304194393`*^9, 3.500703579996239*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"3", "x"}], "-", "1"}]}], ";", 
  RowBox[{"NSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"a", "=", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", "1"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"b", "=", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", "2"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"c", "=", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", "3"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MinimalPolynomial", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "a"}], "+", 
    RowBox[{"3", "b"}]}], ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"MinimalPolynomial", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "a", "+", 
       RowBox[{"a", "^", "2"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]}], "+", 
    RowBox[{"c", "^", "3"}]}], ",", "x"}], "]"}]}], "Input",
 CellChangeTimes->{{3.5007007664582396`*^9, 3.500700768236639*^9}, {
  3.5007008008874393`*^9, 3.5007008268458395`*^9}, {3.5007008651750393`*^9, 
  3.500700902552639*^9}, {3.5007026673338394`*^9, 3.5007026900318394`*^9}}],

Cell["\<\
\:041a\:043e\:0440\:0435\:043d\:044c \:043b\:044e\:0431\:043e\:0433\:043e \
\:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d\:0430 \:0441 \:0430\
\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:043c\
\:0438 \:043a\:043e\:044d\:0444\:0444\:0438\:0446\:0438\:0435\:043d\:0442\
\:0430\:043c\:0438 \:0435\:0441\:0442\:044c \:0430\:043b\:0433\:0435\:0431\
\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:043e\:0435 \:0447\:0438\:0441\
\:043b\:043e.\
\>", "Text",
 CellChangeTimes->{{3.500700964687439*^9, 3.500700991254239*^9}}],

Cell[BoxData[{
 RowBox[{"u", "=", 
  RowBox[{"RootReduce", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"a", "*", "x"}], "+", "b"}], ",", "1"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"MinimalPolynomial", "[", 
  RowBox[{"u", ",", "x"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"N", "[", 
  RowBox[{"u", ",", "100"}], "]"}]}], "Input",
 CellChangeTimes->{{3.500701033155839*^9, 3.500701077225839*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\:041f\:043e\:043b\:0435 \:0430\:043b\:0433\:0435\:0431\:0440\:0430\
\:0438\:0447\:0435\:0441\:043a\:0438\:0445 \:0447\:0438\:0441\:0435\:043b", \
"Section",
 CellChangeTimes->{{3.4920188498248*^9, 3.4920188864068003`*^9}, 
   3.4920191950372*^9, 3.4920193194004*^9, 3.4920194623900003`*^9, {
   3.4986732516514597`*^9, 3.49867326344506*^9}, {3.5007030712334394`*^9, 
   3.500703082481039*^9}},
 Background->RGBColor[0.9, 1, 1]],

Cell[TextData[{
 "\n\:0415\:0441\:043b\:0438 \[Alpha] \:0438 \[Beta]  --- \:0430\:043b\:0433\
\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:0435 \:0447\
\:0438\:0441\:043b\:0430, \:0442\:043e  \:0447\:0438\:0441\:043b\:0430 \
\[Alpha]+\[Beta], \[Alpha]-\[Beta], \[Alpha]\[Beta], \:0430 \:0432 \:0441\
\:043b\:0443\:0447\:0430\:0435, \:0435\:0441\:043b\:0438 \
\[Alpha]\[NotEqual]0, \:0442\:043e \:0438 ",
 Cell[BoxData[
  FormBox[
   FractionBox["\[Alpha]", "\[Beta]"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:044f\:0432\:043b\:044f\:044e\:0442\:0441\:044f  \:0430\:043b\:0433\:0435\
\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:043c\:0438 \:0447\
\:0438\:0441\:043b\:0430\:043c\:0438. \:0418\:0437 \:044d\:0442\:043e\:0439 \
\:0442\:0435\:043e\:0440\:0435\:043c\:044b \:0441\:043b\:0435\:0434\:0443\
\:0435\:0442, \:0447\:0442\:043e \:043c\:043d\:043e\:0436\:0435\:0441\:0442\
\:0432\:043e \:0432\:0441\:0435\:0445 \:0430\:043b\:0433\:0435\:0431\:0440\
\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:0445 \:0447\:0438\:0441\:0435\
\:043b \:044f\:0432\:043b\:044f\:0435\:0442\:0441\:044f \:043f\:043e\:043b\
\:0435\:043c."
}], "Text",
 CellChangeTimes->{{3.4916159007793756`*^9, 3.4916159243509755`*^9}, {
   3.4916160567013755`*^9, 3.491616070444976*^9}, {3.4916161148737755`*^9, 
   3.4916161603165755`*^9}, {3.4916162583469753`*^9, 
   3.4916164015705757`*^9}, {3.4916164462177753`*^9, 3.491616468088976*^9}, {
   3.491616536775776*^9, 3.4916165516737757`*^9}, {3.4916165977873755`*^9, 
   3.4916168257657757`*^9}, {3.491617000626176*^9, 3.4916171616805754`*^9}, {
   3.4916171939101753`*^9, 3.4916172228637753`*^9}, {3.4916172602725754`*^9, 
   3.4916173235773754`*^9}, 3.4920151520285997`*^9, 3.4920153295722*^9, 
   3.4920191950372*^9, 3.4920193194004*^9, 3.4920194623900003`*^9, {
   3.49867352920666*^9, 3.49867354070386*^9}, {3.4986735946486597`*^9, 
   3.4986736131658597`*^9}, 3.49867465110946*^9, {3.4987596512097692`*^9, 
   3.4987596617241697`*^9}, 3.4988336144356003`*^9, {3.5007040462178392`*^9, 
   3.5007042724334393`*^9}, 3.500704311386639*^9}],

Cell[TextData[{
 "\:041f\:0443\:0441\:0442\:044c ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "1"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ",...,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "m"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " --- \:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\
\:043a\:0438\:0435 \:0447\:0438\:0441\:043b\:0430. \:041e\:0431\:043e\:0437\
\:043d\:0430\:0447\:0438\:043c \:0441\:0438\:043c\:0432\:043e\:043b\:043e\
\:043c \[DoubleStruckCapitalQ](",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "1"], TraditionalForm]]],
 ",...,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "m"], TraditionalForm]]],
 ") \:043d\:0430\:0438\:043c\:0435\:043d\:044c\:0448\:0435\:0435 \:043f\:043e\
\:043b\:0435, \:0441\:043e\:0434\:0435\:0440\:0436\:0430\:0449\:0435\:0435 \
\:0432\:0441\:0435 \:0447\:0438\:0441\:043b\:0430 ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "i"], TraditionalForm]]],
 ", \:0430 \:0442\:0430\:043a\:0436\:0435 \:043f\:043e\:043b\:0435 \:0440\
\:0430\:0446\:0438\:043e\:043d\:0430\:043b\:044c\:043d\:044b\:0445 \:0447\
\:0438\:0441\:0435\:043b \[DoubleStruckCapitalQ].  \:042d\:0442\:043e \:043f\
\:043e\:043b\:0435 \:0441\:043e\:0441\:0442\:043e\:0438\:0442 \:0438\:0437 \
\:0432\:0441\:0435\:0432\:043e\:0437\:043c\:043e\:0436\:043d\:044b\:0445 \
\:0434\:0440\:043e\:0431\:0435\:0439 \:0432\:0438\:0434\:0430 ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"A", "(", 
     RowBox[{
      SubscriptBox["\[Xi]", "1"], ",", "...", ",", 
      SubscriptBox["\[Xi]", "m"]}], ")"}], 
    RowBox[{"B", "(", 
     RowBox[{
      SubscriptBox["\[Xi]", "1"], ",", "...", ",", 
      SubscriptBox["\[Xi]", "m"]}], ")"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", \:0433\:0434\:0435 A, B --- \:043c\:043d\:043e\:0433\:043e\:0447\:043b\
\:0435\:043d\:044b \:043e\:0442 \:043f\:0435\:0440\:0435\:043c\:0435\:043d\
\:043d\:044b\:0445 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["x", "1"], ",", "...", ",", 
    SubscriptBox["x", "m"]}], TraditionalForm]]],
 " \:0441 \:0440\:0430\:0446\:0438\:043e\:043d\:0430\:043b\:044c\:043d\:044b\
\:043c\:0438 \:043a\:043e\:044d\:0444\:0444\:0438\:0446\:0438\:0435\:043d\
\:0442\:0430\:043c\:0438. \:0413\:043e\:0432\:043e\:0440\:044f\:0442, \:0447\
\:0442\:043e \:0447\:0438\:0441\:043b\:0430 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Xi]", "1"], ",", "...", ",", 
    SubscriptBox["\[Xi]", "m"]}], TraditionalForm]]],
 " \:043f\:043e\:0440\:043e\:0436\:0434\:0430\:044e\:0442 \:043f\:043e\:043b\
\:0435 \[DoubleStruckCapitalQ](",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "1"], TraditionalForm]]],
 ",...,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "m"], TraditionalForm]]],
 "). \:0412\:0441\:0435 \:044d\:043b\:0435\:043c\:0435\:043d\:0442\:044b \
\:044d\:0442\:043e\:0433\:043e \:043f\:043e\:043b\:044f \:044f\:0432\:043b\
\:044f\:044e\:0442\:0441\:044f \:0430\:043b\:0433\:0435\:0431\:0440\:0430\
\:0438\:0447\:0435\:0441\:043a\:0438\:043c\:0438 \:0447\:0438\:0441\:043b\
\:0430\:043c\:0438."
}], "Text",
 CellChangeTimes->{
  3.4916173289593754`*^9, {3.4916173713757753`*^9, 3.491617390922576*^9}, {
   3.4916174898577757`*^9, 3.4916175602761755`*^9}, {3.4916179758133755`*^9, 
   3.4916180510521755`*^9}, {3.4916183087173758`*^9, 3.491618331711776*^9}, 
   3.4920153295722*^9, 3.4920191950372*^9, 3.4920193194004*^9, 
   3.4920194623900003`*^9, 3.494600271520362*^9, {3.494600466005562*^9, 
   3.4946004669103622`*^9}, 3.4986747765178595`*^9, 3.49867484181946*^9, {
   3.49867491531106*^9, 3.4986749314102597`*^9}, {3.49867502822386*^9, 
   3.49867514414746*^9}, 3.49867519314706*^9, {3.4986752261878595`*^9, 
   3.49867526908786*^9}, {3.49867532365666*^9, 3.4986753357778597`*^9}, 
   3.4986753746374598`*^9, {3.4986754168564596`*^9, 3.4986754702552595`*^9}, {
   3.49867550393566*^9, 3.49867555798966*^9}, {3.49867561285486*^9, 
   3.4986756163024597`*^9}, {3.4986756606064596`*^9, 
   3.4986757847824597`*^9}, {3.49867584322006*^9, 3.49867602829846*^9}, {
   3.49867643556766*^9, 3.49867652751406*^9}, {3.49867656635806*^9, 
   3.4986765800236597`*^9}, {3.49867661715166*^9, 3.49867665468526*^9}, {
   3.4986766945120597`*^9, 3.4986768394204597`*^9}, 3.49867688832646*^9, {
   3.49867697596726*^9, 3.49867704281326*^9}, {3.49867707853726*^9, 
   3.49867717318246*^9}, {3.49867723394446*^9, 3.4986772991992598`*^9}, {
   3.4986773429884596`*^9, 3.49867744488766*^9}, 3.49867749540046*^9, {
   3.4986776132272596`*^9, 3.49867762088686*^9}, {3.4987186597215724`*^9, 
   3.4987186703139725`*^9}, {3.498718700624772*^9, 3.4987189272459726`*^9}, {
   3.4987197498651724`*^9, 3.4987197528603725`*^9}, {3.4987226951763725`*^9, 
   3.498722756047572*^9}, {3.498722862720372*^9, 3.498722949815172*^9}, {
   3.498723008237172*^9, 3.4987232088843727`*^9}, {3.4987232425209723`*^9, 
   3.4987233150297723`*^9}, {3.49875971245537*^9, 3.4987597827177696`*^9}, {
   3.4987607686065693`*^9, 3.4987608023493695`*^9}, {3.4987608417393694`*^9, 
   3.49876084715257*^9}, {3.4987610466921697`*^9, 3.4987611663793697`*^9}, {
   3.4987612240335693`*^9, 3.4987612654479694`*^9}, {3.4987613187843695`*^9, 
   3.4987613509533696`*^9}, {3.49876144814137*^9, 3.4987615443621693`*^9}, {
   3.4988336423596*^9, 3.498833664184*^9}, {3.500704325801039*^9, 
   3.5007046124666395`*^9}, {3.500704647114239*^9, 3.5007047290142393`*^9}, {
   3.500704760557439*^9, 3.500704888452239*^9}, {3.5007049218830395`*^9, 
   3.500704925330639*^9}, {3.500704965734639*^9, 3.500705186599439*^9}, 
   3.5007052509650393`*^9, {3.5007054113330393`*^9, 3.500705412846239*^9}}],

Cell[TextData[{
 "\:041f\:0443\:0441\:0442\:044c \[CurlyTheta] \:0430\:043b\:0433\:0435\:0431\
\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:043e\:0435 \:0447\:0438\:0441\
\:043b\:043e \:0438 \[DoubleStruckCapitalQ](",
 Cell[BoxData[
  FormBox["\[CurlyTheta]", TraditionalForm]]],
 ") --- \:043f\:043e\:0440\:043e\:0436\:0434\:0451\:043d\:043d\:043e\:0435 \
\:0438\:043c \:043f\:043e\:043b\:0435. \:0415\:0441\:043b\:0438 \:0441\:0442\
\:0435\:043f\:0435\:043d\:044c \:0430\:043b\:0433\:0435\:0431\:0440\:0430\
\:0438\:0447\:0435\:0441\:043a\:043e\:0433\:043e \:0447\:0438\:0441\:043b\
\:0430 \[CurlyTheta] \:0440\:0430\:0432\:043d\:0430 n, \:0442\:043e \:043a\
\:0430\:0436\:0434\:044b\:0439 \:044d\:043b\:0435\:043c\:0435\:043d\:0442 \
\[Alpha] \:043f\:043e\:043b\:044f K=\[DoubleStruckCapitalQ](",
 Cell[BoxData[
  FormBox["\[CurlyTheta]", TraditionalForm]]],
 ") \:0435\:0434\:0438\:043d\:0441\:0442\:0432\:0435\:043d\:043d\:044b\:043c \
\:043e\:0431\:0440\:0430\:0437\:043e\:043c \:043f\:0440\:0435\:0434\:0441\
\:0442\:0430\:0432\:043b\:044f\:0435\:0442\:0441\:044f \:0432 \:0432\:0438\
\:0434\:0435 \[Alpha]=",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "0"], "+", 
    RowBox[{
     SubscriptBox["r", "1"], "\[CurlyTheta]"}], "+", "\[Ellipsis]", "+", 
    RowBox[{
     SubscriptBox["r", 
      RowBox[{"n", "-", "1"}]], 
     SuperscriptBox["\[CurlyTheta]", 
      RowBox[{"n", "-", "1"}]]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". \:0418 ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0442\:0430\:043a\:043e\:0435 \:043f\:0440\:0435\:0434\:0441\:0442\:0430\
\:0432\:043b\:0435\:043d\:0438\:0435 \:0437\:0430\:0434\:0430\:0435\:0442\
\:0441\:044f \:043a\:043e\:043c\:0430\:043d\:0434\:043e\:0439 ",
 StyleBox["AlgebraicNumber[\[CurlyTheta],{", "Input"],
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["r", "0"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["r", 
     RowBox[{"n", "-", "1"}]]}], TraditionalForm]], "Input",
  FormatType->"TraditionalForm"], "Input"],
 StyleBox["}]", "Input"],
 ". \:0412 \:0442\:0430\:043a\:043e\:043c \:0432\:0438\:0434\:0435 \:043c\
\:043e\:0436\:043d\:043e \:0432\:044b\:043f\:043e\:043b\:043d\:044f\:0442\
\:044c \:0430\:0440\:0438\:0444\:043c\:0435\:0442\:0438\:0447\:0435\:0441\
\:043a\:0438\:0435 \:043e\:043f\:0435\:0440\:0430\:0446\:0438\:0438 \:0441 \
\:044d\:043b\:0435\:043c\:0435\:043d\:0442\:0430\:043c\:0438 \:043f\:043e\
\:043b\:044f. "
}], "Text",
 CellChangeTimes->{{3.491618061051776*^9, 3.4916180681341753`*^9}, {
   3.4916181098329754`*^9, 3.4916182583449755`*^9}, {3.4916183567185755`*^9, 
   3.4916184318949757`*^9}, {3.4916188772593756`*^9, 3.491618893140176*^9}, {
   3.4916208476953754`*^9, 3.4916208519853754`*^9}, {3.491620882218176*^9, 
   3.4916211147049756`*^9}, {3.4916212368841753`*^9, 
   3.4916212440445757`*^9}, {3.4916214789805756`*^9, 
   3.4916215089637756`*^9}, {3.4916220547921753`*^9, 3.4916220623581753`*^9}, 
   3.4920153295722*^9, 3.4920191950372*^9, 3.4920193194004*^9, 
   3.4920194623900003`*^9, 3.49867451908666*^9, {3.4987189819395723`*^9, 
   3.4987196678715725`*^9}, {3.4987197139383726`*^9, 
   3.4987197458091726`*^9}, {3.4987197795519724`*^9, 
   3.4987200006195726`*^9}, {3.5007054249050393`*^9, 
   3.5007055484882393`*^9}, {3.500705596333439*^9, 3.5007057510542393`*^9}, {
   3.5007057891962395`*^9, 3.5007059358674393`*^9}, {3.500705970764639*^9, 
   3.500706038796239*^9}, {3.500706069918239*^9, 3.500706134861039*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[CurlyTheta]", "=", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"3", "x"}], "-", "1"}], ",", "1"}], "]"}]}], ";", 
  RowBox[{"a", "=", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{"\[CurlyTheta]", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a", "^", "2"}], "-", "a"}], "\[IndentingNewLine]", 
 RowBox[{"1", "/", 
  RowBox[{"(", 
   RowBox[{"a", "-", "1"}], ")"}]}]}], "Input",
 CellChangeTimes->{{3.5007061780886393`*^9, 3.500706209865839*^9}, {
   3.500706242079839*^9, 3.5007063615290394`*^9}, 3.5007066987854395`*^9}],

Cell["\:0412 \:0434\:0440\:0443\:0433\:0438\:0445 \:043e\:0431\:043e\:0437\
\:043d\:0430\:0447\:0435\:043d\:0438\:044f\:0445 \:0438\:043c\:0435\:0435\
\:043c ", "Text",
 CellChangeTimes->{{3.5007063865670395`*^9, 3.500706642937439*^9}}],

Cell[TextData[{
 StyleBox["a=1+\[CurlyTheta]+2", "Input"],
 StyleBox[Cell[BoxData[
  FormBox[
   SuperscriptBox["\[CurlyTheta]", "2"], TraditionalForm]], "Input",
  FormatType->"TraditionalForm"], "Input"],
 StyleBox[",      ", "Input"],
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], "-", "a"}], "=", 
     RowBox[{"4", "+", 
      RowBox[{"17", "\[CurlyTheta]"}], "+", 
      RowBox[{"15", 
       SuperscriptBox["\[CurlyTheta]", "2"]}]}]}], ","}], TraditionalForm]], 
  "Input",
  FormatType->"TraditionalForm"], "Input"],
 StyleBox["      ", "Input"],
 StyleBox[Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", 
     RowBox[{"a", "-", "1"}]], "=", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["31", "3"]}], "-", 
     RowBox[{
      FractionBox["4", "3"], "\[CurlyTheta]"}], "+", 
     RowBox[{
      FractionBox["11", "3"], 
      SuperscriptBox["\[CurlyTheta]", "2"]}]}]}], TraditionalForm]], "Input",
  FormatType->"TraditionalForm"], "Input"],
 "."
}], "Text",
 CellChangeTimes->{{3.5007063865670395`*^9, 3.500706670533839*^9}, {
  3.500706894081839*^9, 3.500706894113039*^9}},
 TextAlignment->Center],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:043c\:043e\:0436\:0435\:0442 \:0432\:044b\:0431\:0438\:0440\:0430\:0442\
\:044c \:043f\:043e\:0440\:043e\:0436\:0434\:0430\:044e\:0449\:0438\:0439 \
\:044d\:043b\:0435\:043c\:0435\:043d\:0442 \:043f\:043e\:043b\:044f \:0432 \
\:0431\:043e\:043b\:0435\:0435 \:043f\:0440\:043e\:0441\:0442\:043e\:043c \
\:0432\:0438\:0434\:0435 \:0442\:0430\:043a, \:0447\:0442\:043e\:0431\:044b \
\:0441\:0442\:0430\:0440\:0448\:0438\:0439 \:043a\:043e\:044d\:0444\:0444\
\:0438\:0446\:0438\:0435\:043d\:0442 \:0435\:0433\:043e \:043c\:0438\:043d\
\:0438\:043c\:0430\:043b\:044c\:043d\:043e\:0433\:043e \:043c\:043d\:043e\
\:0433\:043e\:0447\:043b\:0435\:043d\:0430 \:0431\:044b\:043b \:0440\:0430\
\:0432\:0435\:043d 1. "
}], "Text",
 CellChangeTimes->{{3.5007069176534395`*^9, 3.5007069489938393`*^9}, {
  3.500708080040639*^9, 3.500708107403039*^9}}],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"3", 
       RowBox[{"x", "^", "4"}]}], "+", 
      RowBox[{"x", "^", "3"}], "-", "x", "+", "3"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"1", "/", "3"}], ",", 
     RowBox[{"1", "/", "3"}], ",", "0"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5007069867614393`*^9, 3.500707035339839*^9}, {
  3.5007070665398393`*^9, 3.500707077631439*^9}, {3.5007080219306393`*^9, 
  3.500708061648239*^9}}],

Cell[TextData[{
 "\:0415\:0441\:043b\:0438 \:043f\:043e\:043b\:0435 ",
 StyleBox["K", "Input"],
 " \:043f\:043e\:0440\:043e\:0436\:0434\:0430\:0435\:0442\:0441\:044f \:0430\
\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:043c\
 \:0447\:0438\:0441\:043b\:043e\:043c ",
 StyleBox["a", "Input"],
 ", \:0442\:043e \:043b\:044e\:0431\:043e\:0435 \
\:0447\:0438\:0441\:043b\:043e ",
 StyleBox["b\[Element]K", "Input"],
 " \:043c\:043e\:0436\:0435\:0442 \:0431\:044b\:0442\:044c \:0432\:044b\:0440\
\:0430\:0436\:0435\:043d\:043e \:0432 \:0432\:0438\:0434\:0435 \:043c\:043d\
\:043e\:0433\:043e\:0447\:043b\:0435\:043d\:0430 \:043e\:0442 a \:0441 \:043f\
\:043e\:043c\:043e\:0449\:044c\:044e \:043a\:043e\:043c\:0430\:043d\:0434\
\:044b  ",
 StyleBox["ToNumberField[b,a].", "Input"]
}], "Text",
 CellChangeTimes->{{3.500708649191039*^9, 3.500708902659839*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", 
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"9", "x"}], "+", "81"}], ",", "1"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"3", 
       RowBox[{"x", "^", "4"}]}], "+", 
      RowBox[{"x", "^", "3"}], "-", "x", "+", "3"}], ",", "1"}], "]"}]}], ";", 
  RowBox[{"ToNumberField", "[", 
   RowBox[{"b", ",", "a"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.5007089698802395`*^9, 3.500708970987839*^9}, {
  3.500709008115839*^9, 3.500709065679839*^9}, {3.5007094575206394`*^9, 
  3.500709577375439*^9}}],

Cell[TextData[{
 "\:0442\:043e-\:0435\:0441\:0442\:044c ",
 StyleBox["b =a/3. ", "Input"],
 "\:0418\:043d\:043e\:0439 \:043f\:0440\:0438\:043c\:0435\:0440 "
}], "Text",
 CellChangeTimes->{{3.500709131636639*^9, 3.5007093967742395`*^9}, {
  3.5007096131462393`*^9, 3.500709623535839*^9}, {3.500709667746239*^9, 
  3.500709677293439*^9}, {3.5007098274278393`*^9, 3.5007098591894393`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"3", "x"}], "-", "1"}], ",", "1"}], "]"}]}], ";", 
  RowBox[{"ToNumberField", "[", 
   RowBox[{"a", ",", "I"}], "]"}]}]], "Input",
 CellChangeTimes->{3.5007099109970393`*^9}],

Cell[TextData[{
 "\:041e\:043f\:0440\:0435\:0434\:0435\:043b\:0435\:043d\:043d\:043e\:0435 \
\:0432 \:044d\:0442\:043e\:043c \:043f\:0440\:0438\:043c\:0435\:0440\:0435 \
\:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:043e\
\:0435 \:0447\:0438\:0441\:043b\:043e ",
 StyleBox["a ", "Input"],
 "\:043d\:0435 \:043b\:0435\:0436\:0438\:0442 \:0432 \:043f\:043e\:043b\:0435 \
",
 "\[DoubleStruckCapitalQ](i)."
}], "Text",
 CellChangeTimes->{{3.500709941947439*^9, 3.5007099827882395`*^9}, {
  3.5007100571378393`*^9, 3.500710063097039*^9}}],

Cell[TextData[{
 "\:0412\:0441\:044f\:043a\:043e\:0435 \:043f\:043e\:043b\:0435 K=\
\[DoubleStruckCapitalQ](",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "1"], TraditionalForm]]],
 ",...,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "m"], TraditionalForm]]],
 "), \:043f\:043e\:0440\:043e\:0436\:0434\:0435\:043d\:043d\:043e\:0435 \
\:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\
\:043c\:0438 \:0447\:0438\:0441\:043b\:0430\:043c\:0438 ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "1"], TraditionalForm]]],
 ",...,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "m"], TraditionalForm]]],
 ", \:043c\:043e\:0436\:0435\:0442 \:0431\:044b\:0442\:044c \
\:043f\:043e\:0440\:043e\:0436\:0434\:0435\:043d\:043e \:043e\:0434\:043d\
\:0438\:043c \:0447\:0438\:0441\:043b\:043e\:043c. \:0414\:0440\:0443\:0433\
\:0438\:043c\:0438 \:0441\:043b\:043e\:0432\:0430\:043c\:0438, \:0441\:0443\
\:0449\:0435\:0441\:0442\:0432\:0443\:0435\:0442 \:0442\:0430\:043a\:043e\
\:0435 \:0447\:0438\:0441\:043b\:043e \[CurlyTheta], \:0447\:0442\:043e \
\[DoubleStruckCapitalQ](",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "1"], TraditionalForm]]],
 ",...,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "m"], TraditionalForm]]],
 ")=\[DoubleStruckCapitalQ](\[CurlyTheta]). \:042d\:0442\:043e \:0447\:0438\
\:0441\:043b\:043e \[CurlyTheta] \:043d\:0430\:0437\:044b\:0432\:0430\:0435\
\:0442\:0441\:044f \:043f\:0440\:0438\:043c\:0438\:0442\:0438\:0432\:043d\
\:044b\:043c \:044d\:043b\:0435\:043c\:0435\:043d\:0442\:043e\:043c \:043f\
\:043e\:043b\:044f K. \:041f\:043e\:043b\:0435 K \:0435\:0441\:0442\:044c \
\:043a\:043e\:043d\:0435\:0447\:043d\:043e\:043c\:0435\:0440\:043d\:043e\:0435\
 \:043b\:0438\:043d\:0435\:0439\:043d\:043e\:0435 \:043f\:0440\:043e\:0441\
\:0442\:0440\:0430\:043d\:0441\:0442\:0432\:043e \:043d\:0430\:0434 \
\[DoubleStruckCapitalQ]. \:0415\:0433\:043e \:0440\:0430\:0437\:043c\:0435\
\:0440\:043d\:043e\:0441\:0442\:044c \:0440\:0430\:0432\:043d\:0430 \:0441\
\:0442\:0435\:043f\:0435\:043d\:0438 \:043f\:0440\:0438\:043c\:0438\:0442\
\:0438\:0432\:043d\:043e\:0433\:043e \:044d\:043b\:0435\:043c\:0435\:043d\
\:0442\:0430 \:043f\:043e\:043b\:044f \:0438 \:043d\:0430\:0437\:044b\:0432\
\:0430\:0435\:0442\:0441\:044f \:0441\:0442\:0435\:043f\:0435\:043d\:044c\
\:044e \:043f\:043e\:043b\:044f K. \:041f\:0440\:0438\:043c\:0438\:0442\:0438\
\:0432\:043d\:044b\:0439 \:044d\:043b\:0435\:043c\:0435\:043d\:0442 \:043f\
\:043e\:043b\:044f \:043c\:043e\:0436\:043d\:043e \:0432\:044b\:0431\:0438\
\:0440\:0430\:0442\:044c \:043f\:043e \:0440\:0430\:0437\:043d\:043e\:043c\
\:0443. ",
 StyleBox["Mathematica",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 " \:0434\:0435\:043b\:0430\:0435\:0442 \:044d\:0442\:043e \:0441 \
\:043f\:043e\:043c\:043e\:0449\:044c\:044e \:043a\:043e\:043c\:0430\:043d\
\:0434\:044b ",
 StyleBox["ToNumberField[{", "Input"],
 StyleBox[Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "1"], TraditionalForm]], "Input"], "Input"],
 StyleBox[",...,", "Input"],
 StyleBox[Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "m"], TraditionalForm]], "Input"], "Input"],
 StyleBox["}]", "Input"],
 "."
}], "Text",
 CellChangeTimes->{{3.500708231766239*^9, 3.5007085157954392`*^9}, {
   3.5007085475726395`*^9, 3.500708583546239*^9}, 3.500709708883439*^9, {
   3.5007468384183087`*^9, 3.500746887963909*^9}, {3.500746934966709*^9, 
   3.5007471511827087`*^9}, {3.5007472040043087`*^9, 3.500747240414709*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", 
      RowBox[{"3", "x"}], "-", "1"}], ",", "1"}], "]"}]}], ";", 
  RowBox[{"ToNumberField", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "I"}], "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.500709747306239*^9, 3.500709812483039*^9}, {
  3.5007100704134393`*^9, 3.500710073283839*^9}}],

Cell[TextData[{
 "\:041f\:043e\:043b\:0435, \:043f\:043e\:0440\:043e\:0436\:0434\:0435\:043d\
\:043d\:043e\:0435 \:0447\:0438\:0441\:043b\:0430\:043c\:0438 ",
 StyleBox["a, i", "Input"],
 " \:0438\:043c\:0435\:0435\:0442 \:0441\:0442\:0435\:043f\:0435\:043d\:044c \
6 \:0438 \:043f\:043e\:0440\:043e\:0436\:0434\:0430\:0435\:0442\:0441\:044f \
\:043a\:043e\:0440\:043d\:0435\:043c \[CurlyTheta]  \:043c\:043d\:043e\:0433\
\:043e\:0447\:043b\:0435\:043d\:0430 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "6"], "-", 
    RowBox[{"3", 
     SuperscriptBox["x", "4"]}], "-", 
    RowBox[{"2", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"12", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"12", "x"}], "+", "17"}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " \:0432\:044b\:0434\:0430\:043b\:0430 \:043a\:043e\:044d\:0444\:0444\:0438\
\:0446\:0438\:0435\:043d\:0442\:044b \:043f\:0440\:0435\:0434\:0441\:0442\
\:0430\:0432\:043b\:0435\:043d\:0438\:0439 \:044d\:0442\:0438\:0445 \:0447\
\:0438\:0441\:0435\:043b \:0432 \:0432\:0438\:0434\:0435 \:043c\:043d\:043e\
\:0433\:043e\:0447\:043b\:0435\:043d\:043e\:0432 \:043e\:0442 \[CurlyTheta].  "
}], "Text",
 CellChangeTimes->{{3.5007100986806393`*^9, 3.500710385283839*^9}}],

Cell[TextData[{
 "\:0421\:043b\:0435\:0434 \:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\
\:0447\:0435\:0441\:043a\:043e\:0433\:043e \:0447\:0438\:0441\:043b\:0430 ",
 StyleBox["b", "Input"],
 " \:0435\:0441\:0442\:044c \:0440\:0430\:0446\:0438\:043e\:043d\:0430\:043b\
\:044c\:043d\:043e\:0435 \:0447\:0438\:0441\:043b\:043e, \:0440\:0430\:0432\
\:043d\:043e\:0435 \:0441\:0443\:043c\:043c\:0435 \:0432\:0441\:0435\:0445 \
\:043a\:043e\:0440\:043d\:0435\:0439 \:043c\:0438\:043d\:0438\:043c\:0430\
\:043b\:044c\:043d\:043e\:0433\:043e \:043c\:043d\:043e\:0433\:043e\:0447\
\:043b\:0435\:043d\:0430 ",
 StyleBox["b", "Input"],
 ". \:0421\:043b\:0435\:0434 \:0432\:044b\:0447\:0438\:0441\:043b\:044f\:0435\
\:0442\:0441\:044f \:0441 \:043f\:043e\:043c\:043e\:0449\:044c\:044e \:043a\
\:043e\:043c\:0430\:043d\:0434\:044b ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"AlgebraicNumberTrace", "[", "b", "]"}], "Input"]]],
 "."
}], "Text",
 CellChangeTimes->{{3.500741669592309*^9, 3.5007417549867086`*^9}, {
  3.5007428658939085`*^9, 3.5007428885919085`*^9}, {3.5007429421623087`*^9, 
  3.500742982207509*^9}, {3.500743017791109*^9, 3.5007430465575085`*^9}, {
  3.500743105993509*^9, 3.5007431230443087`*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{"AlgebraicNumberTrace", "[", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"3", 
       SuperscriptBox["x", "4"]}], "+", 
      SuperscriptBox["x", "3"], "-", "x", "+", "3"}], ",", "1"}], "]"}], 
   "]"}], "Input"]], "Input",
 CellChangeTimes->{
  3.500743081298709*^9, {3.5007431475519085`*^9, 3.500743220123109*^9}}],

Cell[TextData[{
 "\:041d\:043e\:0440\:043c\:0430 \:0430\:043b\:0433\:0435\:0431\:0440\:0430\
\:0438\:0447\:0435\:0441\:043a\:043e\:0433\:043e \:0447\:0438\:0441\:043b\
\:0430 ",
 StyleBox["b", "Input"],
 " \:0435\:0441\:0442\:044c \:0440\:0430\:0446\:0438\:043e\:043d\:0430\:043b\
\:044c\:043d\:043e\:0435 \:0447\:0438\:0441\:043b\:043e, \:0440\:0430\:0432\
\:043d\:043e\:0435 \:043f\:0440\:043e\:0438\:0437\:0432\:0435\:0434\:0435\
\:043d\:0438\:044e \:0432\:0441\:0435\:0445 \:043a\:043e\:0440\:043d\:0435\
\:0439 \:043c\:0438\:043d\:0438\:043c\:0430\:043b\:044c\:043d\:043e\:0433\
\:043e \:043c\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d\:0430 ",
 StyleBox["b", "Input"],
 ". \:041d\:043e\:0440\:043c\:0430 \:0432\:044b\:0447\:0438\:0441\:043b\:044f\
\:0435\:0442\:0441\:044f \:0441 \:043f\:043e\:043c\:043e\:0449\:044c\:044e \
\:043a\:043e\:043c\:0430\:043d\:0434\:044b ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"AlgebraicNumberNorm", "[", "b", "]"}], "Input"]]],
 "."
}], "Text",
 CellChangeTimes->{{3.500743260667509*^9, 3.500743324034709*^9}}],

Cell[BoxData[
 StyleBox[
  RowBox[{
   RowBox[{"a", "=", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"3", 
        SuperscriptBox["x", "4"]}], "+", 
       SuperscriptBox["x", "3"], "-", "x", "+", "3"}], ",", "1"}], "]"}]}], 
   ";", 
   RowBox[{"AlgebraicNumberNorm", "[", 
    RowBox[{"3", "-", "a", "-", 
     RowBox[{"a", "^", "2"}]}], "]"}]}], "Input"]], "Input",
 CellChangeTimes->{{3.5007433547199087`*^9, 3.5007433616307087`*^9}, {
  3.500746558803909*^9, 3.500746611672309*^9}}],

Cell[TextData[{
 "\:0410\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\
\:043e\:0435 \:0447\:0438\:0441\:043b\:043e \[Alpha] \:043d\:0430\:0437\:044b\
\:0432\:0430\:0435\:0442\:0441\:044f ",
 StyleBox["\:0446\:0435\:043b\:044b\:043c \
\:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\
\:043c",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 ", \:0435\:0441\:043b\:0438 \:0435\:0433\:043e \
\:043c\:0438\:043d\:0438\:043c\:0430\:043b\:044c\:043d\:044b\:0439 \:043c\
\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d \:0438\:043c\:0435\:0435\
\:0442 \:0446\:0435\:043b\:044b\:0435 \:043a\:043e\:044d\:0444\:0444\:0438\
\:0446\:0438\:0435\:043d\:0442\:044b. \:041f\:0440\:043e\:0432\:0435\:0440\
\:0438\:0442\:044c, \:044f\:0432\:043b\:044f\:0435\:0442\:0441\:044f \:043b\
\:0438 \:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\
\:043a\:043e\:0435 \:0447\:0438\:0441\:043b\:043e \:0446\:0435\:043b\:044b\
\:043c \:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\
\:043a\:0438\:043c \:043c\:043e\:0436\:043d\:043e \:0441 \:043f\:043e\:043c\
\:043e\:0449\:044c\:044e \:043a\:043e\:043c\:0430\:043d\:0434\:044b ",
 StyleBox["AlgebraicIntegerQ[\[Alpha]]. ", "Input"],
 StyleBox["\:0427\:0438\:0441\:043b\:043e, \:043e\:043f\:0440\:0435\:0434\
\:0435\:043b\:044f\:0435\:043c\:043e\:0435 \:0432 \:0441\:043b\:0435\:0434\
\:0443\:044e\:0449\:0435\:043c \:043f\:0440\:0438\:043c\:0435\:0440\:0435, \
\:044f\:0432\:043b\:044f\:0435\:0442\:0441\:044f \:0446\:0435\:043b\:044b\
\:043c \:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\
\:043a\:0438\:043c, \:0432 \:0447\:0435\:043c \:043c\:044b \:0443\:0431\:0435\
\:0436\:0434\:0430\:0435\:043c\:0441\:044f \:043d\:0438\:0436\:0435 \:0434\
\:0432\:0443\:043c\:044f \:0441\:043f\:043e\:0441\:043e\:0431\:0430\:043c\
\:0438. ", "Input",
  FontFamily->"Times New Roman",
  FontWeight->"Plain"]
}], "Text",
 CellChangeTimes->{{3.500743688060709*^9, 3.500743726280709*^9}, {
   3.500743757496309*^9, 3.500743758650709*^9}, {3.500743829490309*^9, 
   3.500743969437909*^9}, {3.500744273435109*^9, 3.500744312887509*^9}, {
   3.500744348315109*^9, 3.500744358938709*^9}, {3.5007444029931087`*^9, 
   3.5007444811335087`*^9}, 3.5007445405851088`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"81", "-", 
         RowBox[{"9", " ", "#1"}], "+", 
         SuperscriptBox["#1", "3"], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", "3"], ",", 
       FractionBox["1", "3"], ",", "0"}], "}"}]}], "]"}]}], ";", 
  StyleBox[
   RowBox[{"AlgebraicIntegerQ", "[", "\[Alpha]", "]"}], 
   "Input"]}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{"MinimalPolynomial", "[", 
   RowBox[{"\[Alpha]", ",", "x"}], "]"}], "Input"]}], "Input",
 CellChangeTimes->{3.500744513597109*^9}],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.5007445244859085`*^9}]
}, Open  ]],

Cell[TextData[{
 "\:0414\:043b\:044f \:043a\:0430\:0436\:0434\:043e\:0433\:043e \:0430\:043b\
\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:043e\:0433\:043e\
 \:0447\:0438\:0441\:043b\:0430 \[Alpha] \:043c\:043e\:0436\:043d\:043e \
\:043d\:0430\:0439\:0442\:0438 \:043d\:0430\:0442\:0443\:0440\:0430\:043b\
\:044c\:043d\:043e\:0435 \:0447\:0438\:0441\:043b\:043e ",
 StyleBox["d", "Input"],
 " \:0442\:0430\:043a\:043e\:0435, \:0447\:0442\:043e ",
 StyleBox["d", "Input"],
 "\[Alpha] \:0435\:0441\:0442\:044c \:0446\:0435\:043b\:043e\:0435 \:0430\
\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:043e\:0435\
 \:0447\:0438\:0441\:043b\:043e. \:041d\:0430\:0438\:043c\:0435\:043d\:044c\
\:0448\:0435\:0435 \:0447\:0438\:0441\:043b\:043e \:0441 \:0442\:0430\:043a\
\:0438\:043c \:0441\:0432\:043e\:0439\:0441\:0442\:0432\:043e\:043c \:043d\
\:0430\:0437\:044b\:0432\:0430\:0435\:0442\:0441\:044f ",
 StyleBox["\:0437\:043d\:0430\:043c\:0435\:043d\:0430\:0442\:0435\:043b\:0435\
\:043c",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 " \[Alpha]. \:0417\:043d\:0430\:043c\:0435\:043d\:0430\:0442\:0435\:043b\
\:044c \:043c\:043e\:0436\:043d\:043e \:043d\:0430\:0439\:0442\:0438 \:0441 \
\:043f\:043e\:043c\:043e\:0449\:044c\:044e \:043a\:043e\:043c\:0430\:043d\
\:0434\:044b ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"AlgebraicNumberDenominator", "[", 
    StyleBox["\[Alpha]",
     FontFamily->"Times New Roman",
     FontWeight->"Plain"], "]"}], "Input"]]],
 ". "
}], "Text",
 CellChangeTimes->{{3.500744630597109*^9, 3.5007447609039087`*^9}, {
  3.500744846001909*^9, 3.5007448880907087`*^9}, {3.5007449256711087`*^9, 
  3.5007449303979087`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Alpha]", "=", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "3"}], "-", "x", "-", "4"}], ",", "1"}], "]"}]}], ";", 
  RowBox[{
   StyleBox["AlgebraicNumberDenominator", "Input"], 
   StyleBox["[", "Input"], 
   RowBox[{
    RowBox[{
     StyleBox["(", "Input"], 
     RowBox[{
      StyleBox[
       StyleBox["\[Alpha]", "Input"],
       FontFamily->"Times New Roman",
       FontWeight->"Plain"], 
      StyleBox["+", "Input"], 
      SuperscriptBox["\[Alpha]", "2"]}], ")"}], "/", "4"}], 
   StyleBox["]", "Input"]}]}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{"MinimalPolynomial", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["(", "Input"], 
      RowBox[{
       StyleBox[
        StyleBox["\[Alpha]", "Input"],
        FontFamily->"Times New Roman",
        FontWeight->"Plain"], 
       StyleBox["+", "Input"], 
       SuperscriptBox["\[Alpha]", "2"]}], ")"}], "/", "4"}], ",", "x"}], 
   "]"}], "Input"]}], "Input",
 CellChangeTimes->{
  3.5007450342471085`*^9, {3.5007450736215086`*^9, 3.5007452191383085`*^9}, {
   3.5007453432831087`*^9, 3.5007454183659086`*^9}}],

Cell[TextData[{
 "\:041c\:043d\:043e\:0436\:0435\:0441\:0442\:0432\:043e \:0432\:0441\:0435\
\:0445 \:0446\:0435\:043b\:044b\:0445 \:0430\:043b\:0433\:0435\:0431\:0440\
\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:0445 \:0447\:0438\:0441\:0435\
\:043b \:0437\:0430\:043c\:043a\:043d\:0443\:0442\:043e \:043e\:0442\:043d\
\:043e\:0441\:0438\:0442\:0435\:043b\:044c\:043d\:043e \:043e\:043f\:0435\
\:0440\:0430\:0446\:0438\:0439 \:0441\:043b\:043e\:0436\:0435\:043d\:0438\
\:044f, \:0432\:044b\:0447\:0438\:0442\:0430\:043d\:0438\:044f \:0438 \:0443\
\:043c\:043d\:043e\:0436\:0435\:043d\:0438\:044f. \:041c\:043d\:043e\:0436\
\:0435\:0441\:0442\:0432\:043e \:0446\:0435\:043b\:044b\:0445 \:0430\:043b\
\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:0445 \
\:0447\:0438\:0441\:0435\:043b \:043f\:043e\:043b\:044f ",
 StyleBox["K",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 "=\[DoubleStruckCapitalQ](",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "1"], TraditionalForm]]],
 ",...,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "m"], TraditionalForm]]],
 "), \:043f\:043e\:0440\:043e\:0436\:0434\:0435\:043d\:043d\:043e\:0433\:043e \
\:0430\:043b\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\
\:043c\:0438 \:0447\:0438\:0441\:043b\:0430\:043c\:0438 ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "1"], TraditionalForm]]],
 ",...,",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Xi]", "m"], TraditionalForm]]],
 ", \:043e\:0431\:0440\:0430\:0437\:0443\:0435\:0442 \:043f\:043e\:0434\:043a\
\:043e\:043b\:044c\:0446\:043e \:044d\:0442\:043e\:0433\:043e \:043f\:043e\
\:043b\:044f, \:043a\:043e\:0442\:043e\:0440\:043e\:0435 \:0431\:0443\:0434\
\:0435\:0442 \:043e\:0431\:043e\:0437\:043d\:0430\:0447\:0430\:0442\:044c\
\:0441\:044f \:0441\:0438\:043c\:0432\:043e\:043b\:043e\:043c ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[DoubleStruckCapitalZ]", "K"], ".", " ", "\:041d\:0430"}], 
   TraditionalForm]]],
 "\:043f\:0440\:0438\:043c\:0435\:0440, ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[DoubleStruckCapitalZ]", "\[DoubleStruckCapitalQ]"], "=", 
    "\[DoubleStruckCapitalZ]"}], TraditionalForm]]],
 ". \:0412 \:043a\:0430\:0436\:0434\:043e\:043c \
\:043a\:043e\:043d\:0435\:0447\:043d\:043e \:043f\:043e\:0440\:043e\:0436\
\:0434\:0435\:043d\:043d\:043e\:043c \:043f\:043e\:043b\:0435 \:0430\:043b\
\:0433\:0435\:0431\:0440\:0430\:0438\:0447\:0435\:0441\:043a\:0438\:0445 \
\:0447\:0438\:0441\:0435\:043b ",
 StyleBox["K",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 " \:0438\:043c\:0435\:0435\:0442\:0441\:044f \:043d\:0430\:0431\:043e\:0440 \
\:0447\:0438\:0441\:0435\:043b ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Omega]", "1"], ",", "\[Ellipsis]", ",", " "}], 
   TraditionalForm]]],
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "n"], TraditionalForm]]],
 ", \:0433\:0434\:0435 n --- \:0441\:0442\:0435\:043f\:0435\:043d\:044c \
\:043f\:043e\:043b\:044f, \:0434\:043b\:044f \:043a\:043e\:0442\:043e\:0440\
\:043e\:0433\:043e  ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[DoubleStruckCapitalZ]", "K"], TraditionalForm]]],
 "=\[DoubleStruckCapitalZ]",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "1"], TraditionalForm]]],
 "+\[Ellipsis]+\[DoubleStruckCapitalZ]",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Omega]", "n"], TraditionalForm]]],
 ". \:042d\:0442\:043e \:043c\:043d\:043e\:0436\:0435\:0441\:0442\:0432\:043e \
\:043d\:0430\:0437\:044b\:0432\:0430\:0435\:0442\:0441\:044f ",
 StyleBox["\:0444\:0443\:043d\:0434\:0430\:043c\:0435\:043d\:0442\:0430\:043b\
\:044c\:043d\:044b\:043c \:0431\:0430\:0437\:0438\:0441\:043e\:043c",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 " \:043f\:043e\:043b\:044f ",
 StyleBox["K",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 ". \:041d\:0430\:0439\:0442\:0438 \:0444\:0443\:043d\:0434\:0430\:043c\:0435\
\:043d\:0442\:0430\:043b\:044c\:043d\:044b\:0439 \:0431\:0430\:0437\:0438\
\:0441 \:043f\:043e\:043b\:044f \[DoubleStruckCapitalQ](\[Alpha]) \
\:043c\:043e\:0436\:043d\:043e \:0441 \:043f\:043e\:043c\:043e\:0449\:044c\
\:044e \:043a\:043e\:043c\:0430\:043d\:0434\:044b ",
 StyleBox["NumberFieldIntegralBasis[\[Alpha]].", "Input"]
}], "Text",
 CellChangeTimes->{{3.500743688060709*^9, 3.500743726280709*^9}, {
   3.500743757496309*^9, 3.500743758650709*^9}, {3.500743829490309*^9, 
   3.500743903512309*^9}, 3.500744563657509*^9, {3.500745461016309*^9, 
   3.5007454860075088`*^9}, {3.5007455196411085`*^9, 
   3.5007455915103087`*^9}, {3.5007456330219088`*^9, 
   3.5007457078863087`*^9}, {3.5007457457631087`*^9, 
   3.5007458599239087`*^9}, {3.5007459365043087`*^9, 3.500746092410709*^9}, {
   3.500746636195509*^9, 3.5007466988607087`*^9}, {3.5007472822227087`*^9, 
   3.5007473194755087`*^9}, {3.5007473649183087`*^9, 3.500747425586709*^9}, {
   3.500747506082709*^9, 3.500747587686309*^9}, 3.500750222126109*^9, {
   3.500750459911109*^9, 3.500750464279109*^9}, {3.5007505116251087`*^9, 
   3.500750513902709*^9}, {3.5007555851819086`*^9, 3.500755681979909*^9}, {
   3.500755737874709*^9, 3.500755756376309*^9}, {3.5007557953919086`*^9, 
   3.500755856107109*^9}, {3.500755898398709*^9, 3.500755901284709*^9}}],

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"3", 
      SuperscriptBox["x", "4"]}], "+", 
     SuperscriptBox["x", "3"], "-", "x", "+", "3"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5007464550015087`*^9, 3.500746484267109*^9}, 
   3.5007465153111086`*^9}],

Cell[TextData[{
 "\:041e\:0431\:0440\:0430\:0442\:0438\:043c\:044b\:0435 \:044d\:043b\:0435\
\:043c\:0435\:043d\:0442\:044b \:043a\:043e\:043b\:044c\:0446\:0430 ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[DoubleStruckCapitalZ]", "K"], TraditionalForm]]],
 " \:043d\:0430\:0437\:044b\:0432\:0430\:044e\:0442\:0441\:044f \:0435\:0434\
\:0438\:043d\:0438\:0446\:0430\:043c\:0438 \:043f\:043e\:043b\:044f ",
 StyleBox["K",
  FontFamily->"Times New Roman",
  FontSlant->"Italic"],
 ". \:0415\:0434\:0438\:043d\:0438\:0446\:044b \:043e\:0431\:0440\:0430\:0437\
\:0443\:044e\:0442 \:043a\:043e\:043d\:0435\:0447\:043d\:043e \:043f\:043e\
\:0440\:043e\:0436\:0434\:0435\:043d\:043d\:0443\:044e \:043c\:0443\:043b\
\:044c\:0442\:0438\:043f\:043b\:0438\:043a\:0430\:0442\:0438\:0432\:043d\:0443\
\:044e \:0433\:0440\:0443\:043f\:043f\:0443. \:041e\:0431\:0440\:0430\:0437\
\:0443\:044e\:0449\:0438\:0435 \:044d\:0442\:043e\:0439 \:0433\:0440\:0443\
\:043f\:043f\:044b \:043c\:043e\:0436\:043d\:043e \:043d\:0430\:0439\:0442\
\:0438 \:0441 \:043f\:043e\:043c\:043e\:0449\:044c\:044e \:043a\:043e\:043c\
\:0430\:043d\:0434\:044b ",
 StyleBox["NumberFieldFundamentalUnits[\[Alpha]].", "Input"]
}], "Text",
 CellChangeTimes->{{3.500755913967509*^9, 3.5007560669411087`*^9}, {
  3.5007561735359087`*^9, 3.5007562241423087`*^9}}],

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "3"], "-", 
     RowBox[{"6", "x"}], "+", "1"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.5007562582127085`*^9, 3.500756352779909*^9}, {
  3.500756530011509*^9, 3.5007565907111087`*^9}, {3.500756742046709*^9, 
  3.500756780828309*^9}, {3.5007573148319087`*^9, 3.500757339511109*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\:0423\:043f\:0440\:0430\:0436\:043d\:0435\:043d\:0438\:044f", "Section",
 CellChangeTimes->{{3.4918870615359964`*^9, 3.4918870647963963`*^9}},
 Background->RGBColor[0.9, 1, 1]],

Cell["", "Text",
 CellChangeTimes->{{3.491888783401596*^9, 3.4918887960219965`*^9}, 
   3.498788197713374*^9}],

Cell[TextData[{
 "1. \:041a\:0430\:043a\:043e\:0435 \:0438\:0437 \:0447\:0438\:0441\:0435\
\:043b ",
 Cell[BoxData[
  FormBox[
   SqrtBox["5"], TraditionalForm]]],
 "+",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     RowBox[{"22", "+", 
      RowBox[{"2", 
       SqrtBox["5"]}]}]], " "}], TraditionalForm]]],
 "\:0438\:043b\:0438 ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox[
     RowBox[{"11", "+", 
      RowBox[{"2", 
       SqrtBox["29"]}]}]], "+", 
    RowBox[{
     SqrtBox[
      RowBox[{"16", "-", 
       RowBox[{"2", 
        SqrtBox["29"]}], "+", 
       RowBox[{"2", 
        SqrtBox[
         RowBox[{"55", "-", 
          RowBox[{"10", 
           SqrtBox["29"]}]}]]}]}]], " ", 
     RowBox[{"\:0431\:043e\:043b\:044c\:0448\:0435", "?"}]}]}], 
   TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.498788212392974*^9, 3.498788270430174*^9}, {
  3.498790228386174*^9, 3.4987906765273743`*^9}, {3.498790792497774*^9, 
  3.4987908468169737`*^9}, {3.498790970321374*^9, 3.498790981271974*^9}, {
  3.4987911109391737`*^9, 3.498791318029174*^9}, {3.500751400216709*^9, 
  3.500751683668709*^9}, {3.500752702411109*^9, 3.500752718416709*^9}, {
  3.5007573809759088`*^9, 3.500757381131909*^9}}],

Cell[TextData[{
 "2. \:041f\:0443\:0441\:0442\:044c \[Zeta] - \:043a\:043e\:043c\:043f\:043b\
\:0435\:043a\:0441\:043d\:044b\:0439 \:043a\:043e\:0440\:0435\:043d\:044c \
\:0442\:0440\:0435\:0442\:044c\:0435\:0439 \:0441\:0442\:0435\:043f\:0435\
\:043d\:0438 \:0438\:0437 \:0435\:0434\:0438\:043d\:0438\:0446\:044b. \:041f\
\:0440\:043e\:0432\:0435\:0440\:0438\:0442\:044c, \:0447\:0442\:043e \:043f\
\:0440\:0438 \:043b\:044e\:0431\:043e\:043c \:043f\:0440\:043e\:0441\:0442\
\:043e\:043c p>7 \:0447\:0438\:0441\:043b\:043e (3\[Zeta] + 2)",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["", 
    RowBox[{"[", 
     RowBox[{"p", "/", "3"}], "]"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "(-3\[Zeta] - 1)",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["", 
    RowBox[{"[", 
     RowBox[{"2", 
      RowBox[{"p", "/", "3"}]}], "]"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " \:0441\:0440\:0430\:0432\:043d\:0438\:043c\:043e \:043f\:043e \:043c\:043e\
\:0434\:0443\:043b\:044e p \:0441 \:043e\:0434\:043d\:0438\:043c \:0438\:0437 \
\:0447\:0438\:0441\:0435\:043b 1, \[Zeta], ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Zeta]", "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ". \:041f\:0440\:043e\:0432\:0435\:0440\:0438\:0442\:044c, \
\:0447\:0442\:043e \:043f\:0440\:0438 p\[Congruent]\[PlusMinus]1(mod 14) \
\:0434\:0430\:043d\:043d\:043e\:0435 \:0447\:0438\:0441\:043b\:043e \:0441\
\:0440\:0430\:0432\:043d\:0438\:043c\:043e \:0441 1."
}], "Text",
 CellChangeTimes->{{3.5007574265591087`*^9, 3.500757549190709*^9}, {
  3.5007594311279087`*^9, 3.5007595037303085`*^9}, {3.5007595435259085`*^9, 
  3.500759909174309*^9}, {3.500760345100709*^9, 3.500760345677909*^9}}],

Cell[TextData[{
 "3. \:041d\:0430\:0439\:0442\:0438 \
\:043c\:0438\:043d\:0438\:043c\:0430\:043b\:044c\:043d\:044b\:0439 \:043c\
\:043d\:043e\:0433\:043e\:0447\:043b\:0435\:043d \:0447\:0438\:0441\:043b\
\:0430 ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]],
  FormatType->"TraditionalForm"],
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Cos", "[", 
     FractionBox[
      RowBox[{"2", "\[Pi]"}], "5"], "]"}], "."}], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Text",
 CellChangeTimes->{{3.500760349172309*^9, 3.500760469183109*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\:041b\:0438\:0442\:0435\:0440\:0430\:0442\:0443\:0440\:0430", "Section",
 CellChangeTimes->{{3.4918863692445965`*^9, 3.491886371834196*^9}},
 Background->RGBColor[0.9, 1, 1]],

Cell["\<\
1. \:0411\:043e\:0440\:0435\:0432\:0438\:0447 \:0417.\:0418., \:0428\:0430\
\:0444\:0430\:0440\:0435\:0432\:0438\:0447 \:0418.\:0420., \:0422\:0435\:043e\
\:0440\:0438\:044f \:0447\:0438\:0441\:0435\:043b, \:041c., \
\:041d\:0430\:0443\:043a\:0430, 1985, 3-\:0435 \:0438\:0437\:0434.
2. \:0411\:0443\:0445\:0448\:0442\:0430\:0431 \:0410.\:0410., \:0422\:0435\
\:043e\:0440\:0438\:044f \:0447\:0438\:0441\:0435\:043b, \:041c., \
\:041f\:0440\:043e\:0441\:0432\:0435\:0449\:0435\:043d\:0438\:0435, 1966. 
3. \:0412\:0438\:043d\:043e\:0433\:0440\:0430\:0434\:043e\:0432 \
\:0418.\:041c., \:041e\:0441\:043d\:043e\:0432\:044b \:0442\:0435\:043e\:0440\
\:0438\:0438 \:0447\:0438\:0441\:0435\:043b, \:041b\:044e\:0431\:043e\:0435 \
\:0438\:0437\:0434\:0430\:043d\:0438\:0435.
4. \:041d\:0435\:0441\:0442\:0435\:0440\:0435\:043d\:043a\:043e \
\:042e.\:0412., \:0422\:0435\:043e\:0440\:0438\:044f \:0447\:0438\:0441\:0435\
\:043b, \:041c., \:0410\:043a\:0430\:0434\:0435\:043c\:0438\:044f, 2008.\
\>", "Text",
 CellChangeTimes->{{3.491886396138996*^9, 3.491886495402996*^9}, {
  3.4918866894025965`*^9, 3.4918867503049965`*^9}, {3.4918868153797965`*^9, 
  3.491886867405796*^9}, {3.4918869319467964`*^9, 3.491886982865196*^9}}]
}, Closed]]
}, Open  ]]
},
WindowSize->{958, 624},
WindowMargins->{{-1, Automatic}, {Automatic, 12}},
Magnification->1.5,
FrontEndVersion->"7.0 for Microsoft Windows (32-bit) (February 18, 2009)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> 
     FrontEnd`FileName[{"Book"}, "Textbook.nb", CharacterEncoding -> 
       "WindowsCyrillic"]]]}, Visible -> False, FrontEndVersion -> 
  "7.0 for Microsoft Windows (32-bit) (February 18, 2009)", StyleDefinitions -> 
  "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 150, 3, 217, "BookChapterNumber"],
Cell[720, 27, 436, 6, 194, "BookChapterTitle",
 CellGroupingRules->{GroupTogetherGrouping, 10000.}],
Cell[1159, 35, 3301, 45, 130, "Text"],
Cell[CellGroupData[{
Cell[4485, 84, 829, 11, 118, "Section"],
Cell[5317, 97, 3997, 64, 159, "Text"],
Cell[9317, 163, 1445, 37, 125, "Input"],
Cell[10765, 202, 1757, 26, 107, "Text"],
Cell[12525, 230, 1182, 36, 134, "Input"],
Cell[13710, 268, 1384, 29, 70, "Text"],
Cell[15097, 299, 558, 15, 43, "Input"],
Cell[15658, 316, 1497, 33, 60, "Text"],
Cell[17158, 351, 281, 4, 43, "Input"],
Cell[17442, 357, 3168, 56, 159, "Text"],
Cell[20613, 415, 1423, 42, 179, "Input"],
Cell[22039, 459, 561, 9, 32, "Text"],
Cell[22603, 470, 479, 13, 98, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[23119, 488, 434, 7, 54, "Section"],
Cell[23556, 497, 2105, 33, 93, "Text"],
Cell[25664, 532, 5661, 112, 126, "Text"],
Cell[31328, 646, 3482, 67, 109, "Text"],
Cell[34813, 715, 716, 20, 98, "Input"],
Cell[35532, 737, 236, 3, 32, "Text"],
Cell[35771, 742, 1183, 38, 46, "Text"],
Cell[36957, 782, 906, 15, 57, "Text"],
Cell[37866, 799, 562, 15, 43, "Input"],
Cell[38431, 816, 880, 17, 59, "Text"],
Cell[39314, 835, 737, 22, 98, "Input"],
Cell[40054, 859, 386, 7, 33, "Text"],
Cell[40443, 868, 322, 10, 43, "Input"],
Cell[40768, 880, 561, 11, 33, "Text"],
Cell[41332, 893, 3517, 73, 131, "Text"],
Cell[44852, 968, 420, 12, 43, "Input"],
Cell[45275, 982, 1320, 29, 84, "Text"],
Cell[46598, 1013, 1204, 22, 59, "Text"],
Cell[47805, 1037, 374, 11, 48, "Input"],
Cell[48182, 1050, 1054, 20, 59, "Text"],
Cell[49239, 1072, 514, 15, 48, "Input"],
Cell[49756, 1089, 2292, 37, 107, "Text"],
Cell[CellGroupData[{
Cell[52073, 1130, 747, 22, 126, "Input"],
Cell[52823, 1154, 75, 1, 42, "Output"]
}, Open  ]],
Cell[52913, 1158, 1691, 33, 83, "Text"],
Cell[54607, 1193, 1161, 37, 78, "Input"],
Cell[55771, 1232, 5257, 111, 188, "Text"],
Cell[61031, 1345, 352, 10, 48, "Input"],
Cell[61386, 1357, 1317, 23, 82, "Text"],
Cell[62706, 1382, 434, 9, 48, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[63177, 1396, 183, 2, 54, "Section"],
Cell[63363, 1400, 110, 2, 32, "Text"],
Cell[63476, 1404, 1220, 40, 68, "Text"],
Cell[64699, 1446, 1714, 36, 83, "Text"],
Cell[66416, 1484, 557, 16, 46, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[67010, 1505, 181, 2, 54, "Section"],
Cell[67194, 1509, 1229, 18, 238, "Text"]
}, Closed]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
